/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.help;

import com.ibm.websm.bridge.WRemoteException;
import com.ibm.websm.bridge.WSession;
import com.ibm.websm.bridge.WSessionMgr;
import com.ibm.websm.console.WAppContext;
import com.ibm.websm.console.WConsole;
import com.ibm.websm.console.plugin.WPluginRef;
import com.ibm.websm.diagnostics.Diag;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.help.WHelpKey;
import com.ibm.websm.help.WJavaHelpSystem;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;

public class HscHelpSystem
extends WJavaHelpSystem {
    private String _lang = System.getProperty("MessageLang");
    private String _tipTarget = " 0 ";
    private String _url = "";
    private final String _absHelpDir = "/opt/hsc/help";
    private final String _docServer = "";
    private final String _helpSearch = "HscHelpSearch.hs";
    private final String _helpOnHelp = "HscHelpOnHelp.hs";

    public HscHelpSystem(WAppContext wAppContext) {
        super(wAppContext);
        if (this._lang.trim().length() == 0) {
            this._lang = "en_US";
        }
    }

    public void setDocumentServerName() {
        this._docServerName = "";
    }

    public void setHelpDir() {
        this._helpDir = "help";
    }

    public void setAbsoluteHelpDir() {
        this._absoluteHelpDir = "/opt/hsc/help";
    }

    public void setHelpSearchFileName() {
        this._helpSearchFileName = "HscHelpSearch.hs";
    }

    public void setHelpOnHelpFileName() {
        this._helpOnHelpFileName = "HscHelpOnHelp.hs";
    }

    public void displayExtendedHelp(WHelpKey wHelpKey) {
        this._tipTarget = " 0 ";
        this.loadHelpContents(wHelpKey);
    }

    public void displayHelpSearch() {
        this._tipTarget = " 1 ";
        WHelpKey wHelpKey = new WHelpKey(this._lang + "/" + "HscHelpSearch.hs", null, 103);
        this.loadHelpContents(wHelpKey);
    }

    public void displayHelpOnHelp() {
        this._tipTarget = " 2 ";
        WHelpKey wHelpKey = new WHelpKey(this._lang + "/" + "HscHelpOnHelp.hs", null, 103);
        this.loadHelpContents(wHelpKey);
    }

    public void displayEmbeddedHelp(WHelpKey wHelpKey) {
        this._tipTarget = " " + wHelpKey.getHelpID() + " ";
        WHelpKey wHelpKey2 = new WHelpKey(this.getHscHelpSet(), null, 103);
        this.loadHelpContents(wHelpKey2);
    }

    public void displayKeysHelp(WHelpKey wHelpKey) {
        this._tipTarget = " " + wHelpKey.getHelpID() + " ";
        WHelpKey wHelpKey2 = new WHelpKey(this.getHscHelpSet(), null, 103);
        this.loadHelpContents(wHelpKey2);
    }

    public void displayHelpSetTarget(WHelpKey wHelpKey) {
        Object var2_2 = null;
        String string = this.getHscHelpSet();
        String string2 = wHelpKey.getHelpID();
        this.invokeHelp(string2 + string);
    }

    private String getHscHelpSet() {
        WHelpKey wHelpKey = null;
        WPluginRef wPluginRef = WConsole.getConsole().getMainWindow().getSubWindowMgr().getCurrentSubWindow().getScopePane().getSelectedPluginRef();
        if (wPluginRef != null) {
            wHelpKey = (WHelpKey)wPluginRef.getExtendedHelpKey();
        }
        return wHelpKey.getHelpID();
    }

    private void invokeHelp(String string) {
        block7: {
            try {
                if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
                    String string2 = "/opt/IBMJava2-13/";
                    File file = new File("/opt/IBMJava2-13/jre/bin/java");
                    string2 = file.exists() ? string2 + "jre/bin/java " : string2 + "jre/bin/java ";
                    String string3 = string2 + "  -Djava.security.manager -cp " + System.getProperty("java.class.path") + "  com.ibm.hsc.common.help.LoadHscHelp " + string;
                    Object[] objectArray = new Object[]{string3};
                    Class<?> clazz = ((Object)((Object)this)).getClass();
                    Method[] methodArray = clazz.getMethods();
                    int n = 0;
                    while (n < methodArray.length) {
                        if (methodArray[n].getName().equals("loadHelp")) {
                            methodArray[n].invoke(null, objectArray);
                            break block7;
                        }
                        ++n;
                    }
                    break block7;
                }
                String[] stringArray = new String[]{this._tipTarget, this._url};
                Object[] objectArray = new Object[]{stringArray};
                Class<?> clazz = Class.forName("com.ibm.hsc.common.help.LoadHscHelp");
                Method[] methodArray = clazz.getMethods();
                int n = 0;
                while (n < methodArray.length) {
                    if (methodArray[n].getName().equalsIgnoreCase("main")) {
                        methodArray[n].invoke(null, objectArray);
                        break;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void loadHelp(String string) throws Throwable {
        if (IDebug.enabled) {
            IDebug.println((String)("calling loadHelp() : " + string));
        }
        System.out.println("Please wait while launching the HSC Help...");
        Runtime runtime = Runtime.getRuntime();
        runtime.exec(string);
    }

    private boolean checkDocServer(String string) {
        if (IDebug.enabled) {
            IDebug.println((String)("checkDocServer : " + string));
        }
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        if ("" == null) {
            return false;
        }
        if ("".trim().length() == 0) {
            return false;
        }
        try {
            URL uRL = new URL("http", "", string);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    private boolean checkWebSMServer() {
        try {
            WSession wSession;
            if (IDebug.enabled) {
                IDebug.println((String)"checkWebSMServer");
            }
            return !(wSession = WSessionMgr.getSessionMgr().getSession(this.getHostName())).isLocal();
        }
        catch (WRemoteException wRemoteException) {
            this.errorHandler(wRemoteException.toString());
            return false;
        }
    }

    private boolean checkLocalFileSystem(String string) {
        if (IDebug.enabled) {
            IDebug.println((String)("checkLocalFileSystem : " + string));
        }
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        try {
            URL uRL = new URL("file:" + string);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    private void errorHandler(String string) {
        Diag.programError((String)string);
    }

    private String getURL(String string) throws Throwable {
        if (IDebug.enabled) {
            IDebug.println((String)("getURL() : " + string));
        }
        if (string.substring(0, 2).equals("//")) {
            return string.substring(1, string.length());
        }
        if (IDebug.enabled) {
            IDebug.println((String)"check for Doc Server...");
        }
        if (this.checkDocServer(string)) {
            return "/opt/hsc/help/" + string;
        }
        if (IDebug.enabled) {
            IDebug.println((String)"check for WebSM Server...");
        }
        if (this.checkWebSMServer()) {
            return "/opt/hsc/help/" + string;
        }
        if (IDebug.enabled) {
            IDebug.println((String)"check for Local File System...");
        }
        if (this.checkLocalFileSystem(string)) {
            return "/opt/hsc/help/" + string;
        }
        this.errorHandler("Could not find the help set");
        return null;
    }

    private String getHostName() {
        String string = WConsole.getConsole().getMainWindow().getSubWindowMgr().getCurrentSubWindow().getScopePane().getSelectedPluginRef().getHostname();
        if (IDebug.enabled) {
            IDebug.println((String)("getHostName : " + string));
        }
        return string;
    }

    protected void loadHelpContents(WHelpKey wHelpKey) {
        try {
            this._url = this.getURL(wHelpKey.getHelpID());
            if (IDebug.enabled) {
                IDebug.println((String)("getURL() returns : " + this._url));
            }
            if (this._url != null) {
                if (IDebug.enabled) {
                    IDebug.println((String)"invoking invokeHelp()...");
                }
                this.invokeHelp(this._tipTarget + this._url);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

